require 'page-object'
require 'base'

class Request_Settings < Base
  include PageObject
  def initialize(driver)
    super(driver)
  end

  h4(:type_of_care_table_title, :id=>"clinic-profile-based-on-types-of-care-heading")
  span(:required_field_label, :css=>".manage-settings-content > span[required-field]")
  h3(:request_settings_heading, :id=>"request-settings-heading")
  p(:instructional_text, :css=>".manage-settings-content > p")

#Primary Care

  span(:primarycareOption, :css => ".list-table span:nth-child(2) .cell-content")
  span(:primarycareOptionLastSeen, :css => ".list-table span:nth-child(3) .cell-content")

  select_list(:primaryCare, :id => "primary-care-request-supported")
  select_list(:audiology, :id => "audiology-request-supported")
  select_list(:optometry, :id => "optometry-request-supported")
  select_list(:outpatientMentalHealth, :id => "outpatient-mental-health-request-supported")

#Last seen within (months) column
  select_list(:audiologyLastSeen, :id => "audiology-request-last-seen")
  select_list(:optometryLastSeen, :id => "optometry-request-last-seen")
  select_list(:outpatientMentalHealthLastSeen, :id => "outpatient-mental-health-request-last-seen")

 #submitted request limit column
  select_list(:primaryCareRequestLimit, :id=>'primary-care-request-limit')
  select_list(:audiologyRequestLimit, :id=>'audiology-request-limit')
  select_list(:optometryRequestLimit, :id=>'optometry-request-limit')
  select_list(:outpatientMentalHealthRequestLimit, :id=>'outpatient-mental-health-request-limit')

  h4(:customRequestHeading, :id=>'custom-requests-heading')
  div(:expressCareSection, :css=>'.custom-requests')

  #Custom Request
  radio_button(:expressCareNotSupported, :id=>'expressCareNotSupported')
  radio_button(:expressCareSupported, :id=>'expressCareSupported')
  select_list(:expressCareSubmittedRequestLimit, :name=>'express-care-submitted-request-limit')

  #Day field
  #Monday
  checkbox(:monday, :id=>'express-care-MONDAY')
  text_field(:mondayStartTime, :id=>'MONDAY-start-time')
  text_field(:mondayEndTime, :id=>'MONDAY-end-time')

  #Tuesday
  checkbox(:tuesday, :id=>'express-care-TUESDAY')
  text_field(:tuesdayStartTime, :id=>'TUESDAY-start-time')
  text_field(:tuesdayEndTime, :id=>'TUESDAY-end-time')

  #Wednesday
  checkbox(:wednesday, :id=>'express-care-WEDNESDAY')
  text_field(:wednesdayStartTime, :id=>'WEDNESDAY-start-time')
  text_field(:wednesdayEndTime, :id=>'WEDNESDAY-end-time')

  #Thursday
  checkbox(:thursday, :id=>'express-care-THURSDAY')
  text_field(:thursdayStartTime, :id=>'THURSDAY-start-time')
  text_field(:thursdayEndTime, :id=>'THURSDAY-end-time')

  #Friday
  checkbox(:friday, :id=>'express-care-FRIDAY')
  text_field(:fridayStartTime, :id=>'FRIDAY-start-time')
  text_field(:fridayEndTime, :id=>'FRIDAY-end-time')

  #Saturday
  checkbox(:saturday, :id=>'express-care-SATURDAY')
  text_field(:saturdayStartTime, :id=>'SATURDAY-start-time')
  text_field(:saturdayEndTime, :id=>'SATURDAY-end-time')

  #Sunday
  checkbox(:sunday, :id=>'express-care-SUNDAY')
  text_field(:sundayStartTime, :id=>'SUNDAY-start-time')
  text_field(:sundayEndTime, :id =>'SUNDAY-end-time')

#Buttons
  button(:typeOfCareReset, :id => "type-of-care-reset-btn")
  button(:topSave, :id => "request-top-save-btn")
  button(:expressCareCancel, :id => "expresscare-reset-btn")
  button(:bottomSave, :id => "request-bottom-save-btn")

end



